/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationSolution;

import java.text.NumberFormat;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Product {

    //These are the properties that EVERY product has.
    private String name;
    private String brand;
    private Description description = new Description();
    private Colour colour;
    private double price;

    //Constructors
    public Product() {
    }

    public Product(String name) {
        this.name = name;
    }

    public Product(String name, String description, double price) {
        this(name);
        enterDescription(description);
        setPrice(price);
    }

        //Getter and Setter for colour
    public void setColour(String colour) {
        //Limit product colours to just Red,Blue,Black and Green.
        switch (colour) {
            case "Red": 
                this.colour = Colour.RED;
                break;
            case "Blue":
                this.colour = Colour.BLUE;
                break;
            case "Black":
                this.colour = Colour.BLACK;
                break;
            case "Green":
                this.colour = Colour.GREEN;
                break;
            default:
                System.out.println("The products colour must be either Red, Blue, Black or Green");
        }
    }

    public String getColour() {
        return this.colour.name;
    }

    public void enterDescription(String comment, String country, int height, int weight) {
        this.description = new Description(comment, country, height, weight);
    }

    public void enterDescription(String comment) {
        this.description = new Description(comment);
    }

    //This method will be used whenever anyone want to print out the details of a product.
    public void printProduct() {
        //Print out Name, Description and Price
        System.out.println("Name: " + getName());
        System.out.println("Description: " + getDescription());
        System.out.println("Price: " + getPrice());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getDescription() {
        return description.comments
                + " Country: " + description.country
                + " Height: " + description.height
                + " Weight: " + description.weight;
    }

    public String getPrice() {
        //Define our format as the default currency.
        NumberFormat defaultFormat = NumberFormat.getCurrencyInstance();
        
        //return the price in the default format.
        return defaultFormat.format(price);
    }

    public void setPrice(double price) {
            if (price >= 0) {
                this.price = price;
            } else {//Price is negative
                System.out.println("You can not enter a negative price.");
            }
    }
}
